<?php
function jsonfetchconvert($api_type,$graph_api_version,$ad_account_id,$api_data_request,$time_range_start,$time_range_stop,$breakdowns,
                            $time_increment,$level,$date_preset,$api_access_token){
    switch ($api_type){
        case "facebook":
            $apiurl = 'https://graph.facebook.com/'.$graph_api_version.'/act_'.$ad_account_id.'/'.$api_data_request.'&limit=900';
            if(isset($time_range_start) && isset($time_range_stop)){
                $apiurl .='&time_range={since:%27'.$time_range_start.'%27,until:%27'.$time_range_stop.'%27}';
            };
            if(isset($date_preset)){
                $apiurl .='&date_preset='.$date_preset;
            };
            if(isset($time_increment)){
                $apiurl .='&time_increment='.$time_increment;
            };
            if(isset($breakdowns)){
                $breakdownlisted = implode(",",$breakdowns);
                $apiurl .='&breakdowns='.$breakdownlisted;
            };
            if(isset($level)){
                $apiurl .='&level='.$level;
            };
            $apiurl .= '&access_token='.$api_access_token;
        break;
    }
    $json = curl_get_file_contents($apiurl);
    if(!isset($json)){
        sleep(20);
        $json = curl_get_file_contents($apiurl);
    }
    $converted_json = json_decode($json);
    while(isset($converted_json->paging->next)){
        $presave_converted_json = $converted_json;
        $nextpage_json =  curl_get_file_contents($presave_converted_json->paging->next);
        if(!isset($nextpage_json)){
            sleep(20);
            $nextpage_json = curl_get_file_contents($presave_converted_json->paging->next);
        }
        $nextpage_converted_json = json_decode($nextpage_json);
        if(isset($nextpage_converted_json->data)){
            $first_data_array = $presave_converted_json->data;
            $second_data_array = $nextpage_converted_json->data;
            $merged_array = array_merge($first_data_array,$second_data_array);
            $converted_json->data = $merged_array;
        }else{
            $nextpage_converted_json->paging->next = null; 
        }
        if(isset($nextpage_converted_json->paging->next)){
            $converted_json->paging->next = $nextpage_converted_json->paging->next;
        }else{
            $converted_json->paging->next = null ;
        }
        
    }

    return $converted_json;
}; 
function apijsonscript($api_type,$converted_json,$api_account_name,$current_script_name){
    $apitargetdata = null;
    switch ($api_type){
        case "facebook":
            if(isset($converted_json->data)){
                $apitargetdata = $converted_json->data ;
            }else{
                echo "Skipping current account : '$api_account_name' due to Facebook API did not return with expected Data on '$current_script_name'";
                break;
                $apitargetdata = (array) null;;
            }   
        break;
    }
    return $apitargetdata;
};
function apijsonscriptconfigs($api_type,$converted_json,$counter){
    $apitargetdata = null;
    switch ($api_type){
        case "facebook":
            $apitargetdata = $converted_json->data[$counter];
        break;
    }
    return $apitargetdata;
};
function apijsonscriptconfigure($api_type,$converted_json,$counter,$apidatavalue,$api_data_array,$action_stat,$cost_action_stat){
    $apitargetdata = null;
    switch ($api_type){
        case "facebook":
            $is_cost_action_var = false;
            $is_action_var = false;
            if($action_stat == true){
                if(array_key_exists('actions', get_object_vars($converted_json->data[$counter]))){
                    $max_action_api_counter = count($converted_json->data[$counter]->actions);
                }else{
                    $max_action_api_counter = 0;
                }

                $action_api_counter = 0;
                while ($action_api_counter < $max_action_api_counter){
                    if($apidatavalue == $converted_json->data[$counter]->actions[$action_api_counter]->action_type) {
                        $apitargetdata = $converted_json->data[$counter]->actions[$action_api_counter]->value;
                        $is_action_var = true;
                        $action_api_counter = $max_action_api_counter;/*used to stop loop when result is achieved*/
                    }
                    $action_api_counter += 1;
                }

            }
            if($cost_action_stat == true && $is_action_var == false){

                if(array_key_exists('cost_per_action_type', get_object_vars($converted_json->data[$counter]))){
                    $max_cost_action_api_counter = count($converted_json->data[$counter]->cost_per_action_type);
                }else{
                    $max_cost_action_api_counter = 0;
                }
                
                $cost_action_api_counter = 0;
                while($cost_action_api_counter < $max_cost_action_api_counter){
                    $try_get_cost = substr($apidatavalue, 0, 5);
                    if($try_get_cost == "cost_" ){
                        $cost_apidatavalue = str_replace('cost_','',$apidatavalue);
                        if($cost_apidatavalue == $converted_json->data[$counter]->cost_per_action_type[$cost_action_api_counter]->action_type) {
                            $apitargetdata = $converted_json->data[$counter]->cost_per_action_type[$cost_action_api_counter]->value;
                            $is_cost_action_var = true;
                            $cost_action_api_counter = $max_cost_action_api_counter;/*used to stop loop when result is achieved*/
                        }
                    }
                    $cost_action_api_counter += 1;
                }
            }
            if($is_action_var == true || $is_cost_action_var == true){
                $is_action_var = false;
                $is_cost_action_var = false;
            }elseif(array_key_exists($apidatavalue, get_object_vars($converted_json->data[$counter]))) {
                $apitargetdata = $converted_json->data[$counter]->$apidatavalue;
            }else{
                $apitargetdata = null;
            }
            
        break;
    }
    return $apitargetdata;
}; 
/*^These need to add new case for new api type^*/ 
function addstmtadsquery($sql_table_name,$api_data_array,$database,$table_column_name,$api_type){
        
        $rowsetcounter = 0;
        $rowsetcountedarray = count($api_data_array);
        $valueset = implode("` , `", $table_column_name);
        $querytext = "INSERT INTO $database.$sql_table_name (`$valueset`";
        switch ($api_type){
            case "facebook" :
                $querytext .= ", `accountName`";
            break;

        }
        $querytext .= ") VALUES (";
    
    While($rowsetcounter < $rowsetcountedarray){
        $querytext .= "?";

    $rowsetcounter += 1;
    if($rowsetcounter == $rowsetcountedarray){
        $querytext .= ", ? );";
    
    }else{
    $querytext .= " , ";
    };
        
    };
    return $querytext;
};
function updatestmtadsquery($sql_table_name,$counter,$api_data_array,$database,$searchrowtablecolumn,$table_column_name){    
    $rowsetcounter = 0;
    $rowsetcountedarray = count($api_data_array);
    $querytext = "UPDATE ".$database.".".$sql_table_name." SET ";

    While($rowsetcounter < $rowsetcountedarray){
        $api_data_arrayconverted = $api_data_array[$rowsetcounter];       
        $tableupdate = $table_column_name[$rowsetcounter];
        $querytext .= "`$tableupdate`";
        $querytext .= " = ? ";
        $rowsetcounter += 1;

        if($rowsetcounter == $rowsetcountedarray){
            $querytext .= "  WHERE ";
        }else{
            $querytext .= " , ";
        };
    };
    $rowsetcounter = 0;
    $rowsetcountedarray = count($searchrowtablecolumn);
    While($rowsetcounter < $rowsetcountedarray){
        $apidateconditionconverted = $searchrowtablecolumn[$rowsetcounter];
        $apidateconditionconverted = $table_column_name[$apidateconditionconverted];
        $querytext .= "`$apidateconditionconverted`";
        $querytext .= " = ?";
        $rowsetcounter += 1;
        if($rowsetcounter == $rowsetcountedarray){
            $querytext .= " ;";
        }else{
            $querytext .= " AND ";
        };
    };
    return $querytext;
};
function stmtsetbindparamadd($counter,$converted_json,$api_data_array,$api_type,$action_stat,$cost_action_stat){
        
    $rowsetcounter = 0;
    $rowsetcountedarray = count($api_data_array);
    $querytext = array();
    While($rowsetcounter < $rowsetcountedarray){
        $api_data_arrayconverted = $api_data_array[$rowsetcounter];
        $checknullvalue = apijsonscriptconfigure($api_type,$converted_json,$counter,$api_data_arrayconverted,$api_data_array,
                                                    $action_stat,$cost_action_stat);
        if(isset($checknullvalue)){
            array_push($querytext,$checknullvalue);
        }else{
        array_push($querytext,"NULL");
        };
        $rowsetcounter += 1;
    };
    return $querytext;
};
function stmtsetbindparamup($counter,$converted_json,$api_data_array,$api_type,$update_condition_array,$action_stat,$cost_action_stat){
        
    $rowsetcounter = 0;
    $rowsetcountedarray = count($api_data_array);
    $querytext = array();
    While($rowsetcounter < $rowsetcountedarray){
        $api_data_arrayconverted = $api_data_array[$rowsetcounter];
        $checknullvalue = apijsonscriptconfigure($api_type,$converted_json,$counter,$api_data_arrayconverted,$api_data_array,
                                                $action_stat,$cost_action_stat,$cost_action_stat);
        if(isset($checknullvalue)){
            array_push($querytext,$checknullvalue); 
        }else{
        array_push($querytext,"NULL");
        };
    $rowsetcounter += 1;    
    };
    $rowsetcounter = 0;
    $rowsetcountedarray = count($update_condition_array);
    While($rowsetcounter < $rowsetcountedarray){
        $api_data_arrayconverted = $update_condition_array[$rowsetcounter];
        $queryvalues = apijsonscriptconfigure($api_type,$converted_json,$counter,$api_data_arrayconverted,$api_data_array,
                                                $action_stat,$cost_action_stat);    
        array_push($querytext,$queryvalues);
        $rowsetcounter += 1;
    }
    return $querytext;
};
function autodatacasting($originaldata,$api_data_array,$data_type_stmt){
    $maxcount = strlen($data_type_stmt);
    $counter = 0 ;
    While($counter < $maxcount){
        $arraydatacheck = substr($data_type_stmt, $counter, 1);
        $datapendingchange = $originaldata[$counter];
        switch ($arraydatacheck){
            case "i":
                $originaldata[$counter]=(int)$datapendingchange;
            break;
            case "d":
                $originaldata[$counter]=(double)$datapendingchange;
            break;
        }
    $counter += 1 ;
    }
    return $originaldata;
};
function autodatacastingwhere($originaldata,$api_data_array,$data_type_stmt,$datatypepos){
    $maxcount = count($api_data_array);
    $counter = 0 ;
    While($counter < $maxcount){
        $substrcounter = $datatypepos[$counter];
        $arraydatacheck = substr($data_type_stmt, $substrcounter, 1);
        $datapendingchange = $originaldata[$counter];
        switch ($arraydatacheck){
            case "i":
                $originaldata[$counter]=(int)$datapendingchange;
            break;
            case "d":
                $originaldata[$counter]=(double)$datapendingchange;
            break;
        }
    
        $counter += 1 ;
    }
    return $originaldata;
};
function newtablecreate($table_column_name,$custom_column_stat,$data_type_stmt,$table_position,$database,$sql_table_name,$api_type){
    $counter = 0;
    $maxcount = count($table_column_name);
    $querytext = "CREATE TABLE $database.$sql_table_name
    ( `rowId` int NOT NULL AUTO_INCREMENT, ";
    While($counter < $maxcount){
        $newcolumnname = $table_column_name[$counter];
            if(isset($custom_column_stat)){
                $newcolumntype = $custom_column_stat[$counter];
            }else{
                $shortnewcolumntype = substr($data_type_stmt, $counter, 1);;
        switch ($shortnewcolumntype){
            case "i":
                $newcolumntype = "bigint";
            break;
            case "s":
                $newcolumntype = "varchar(255)";
            break;
            case "d":
                $newcolumntype = "decimal(26,10)";
            break;
        }
            }
        $querytext .= "`$newcolumnname` $newcolumntype NULL ";
        $counter += 1;
    if($counter == $maxcount){
        switch ($api_type){
            case "facebook":
                $querytext .= ",`accountName` varchar(30) NULL";
            break;
        }
        $querytext .= " , PRIMARY KEY (rowId) , UNIQUE INDEX ( `";
    }else{
        $querytext .= " , " ;
    }   
    };
    $counter = 0;
    $maxcount = count($table_position);
    while($counter < $maxcount){
    $current_position = $table_position[$counter];
    $querytext .= $table_column_name[$current_position];
    $counter += 1 ; 
    if($counter == $maxcount){
        $querytext .= "` ));";
    }else{
        $querytext .= "` , `" ;
    }   
    };
    return $querytext; 
}
function findtableposition($api_data_array,$update_condition_array){
    $counter = 0 ; 
    $max_counter = count($update_condition_array);
    $selected_position = array();
    while($counter < $max_counter){
        $api_counter = 0 ; 
        $max_api_counter = count($api_data_array);
        while($api_counter < $max_api_counter){
            if(strcmp($api_data_array[$api_counter], $update_condition_array[$counter]) == 0){
                array_push($selected_position,$api_counter);
            }
            $api_counter += 1;
        } 
        $counter += 1;
    };
    return $selected_position;
}
Function search_and_decide_add_update($counter,$database,$sql_table_name,$api_data_array,$update_condition_array,$api_type,$converted_json,
                                        $action_stat,$cost_action_stat,$table_column_name,$data_type_stmt,$stmt,$api_account_name){
    $seachforkeyvaluequery = "SELECT * FROM $sql_table_name Where ";
    $searchrowcounter = 0;
    $searchrowrownum = count($api_data_array);
    $searchrowwheretablecolumn = count($update_condition_array);
    $searchrowtablecolumn = array();
    while($searchrowcounter < $searchrowwheretablecolumn){
        $sqltablecounter = 0 ;
        $sqltablecolname = $update_condition_array[$searchrowcounter];
            while($sqltablecounter <  $searchrowrownum){
                $apidataname = $api_data_array[$sqltablecounter];
                if($apidataname == $sqltablecolname){
                    array_push($searchrowtablecolumn , $sqltablecounter);
                 };
                $sqltablecounter += 1 ;
            };
        $sqltablecounter = 0 ;
        $searchrowcounter += 1 ;
    };
    $data_type_stmtupdate = NULL;
    $whereconvalue = array();
    while($sqltablecounter <  $searchrowwheretablecolumn){
        $updateconapi = $update_condition_array[$sqltablecounter];
        array_push($whereconvalue, apijsonscriptconfigure($api_type,$converted_json,$counter,$updateconapi,$api_data_array,
                                                        $action_stat,$cost_action_stat));
        $updateconsql = $searchrowtablecolumn[$sqltablecounter];
        $wherecontype = $table_column_name[$updateconsql];
        $seachforkeyvaluequery .= "`$wherecontype` = ? ";
        $data_type_stmtupdate .= substr($data_type_stmt, $updateconsql, 1);
        $sqltablecounter += 1;
        if($sqltablecounter !==  $searchrowwheretablecolumn){
            $seachforkeyvaluequery .= " AND ";
        };
    };
    $seachforkeyvaluequery .= " ;";
    mysqli_stmt_prepare($stmt, $seachforkeyvaluequery); 
    $whereconvalue = autodatacastingwhere($whereconvalue,$update_condition_array,$data_type_stmt,$searchrowtablecolumn);
    mysqli_stmt_bind_param($stmt, $data_type_stmtupdate, ...$whereconvalue);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_store_result($stmt);  
    if(mysqli_stmt_num_rows($stmt) == 1){
        $insertdetaileddateadsquery = updatestmtadsquery($sql_table_name,$counter,$api_data_array,$database,
                                                        $searchrowtablecolumn,$table_column_name);
        $addstmtquery = stmtsetbindparamup($counter,$converted_json,$api_data_array,$api_type,$update_condition_array,
                                            $action_stat,$cost_action_stat);
        $stmtdatatype = $data_type_stmt.$data_type_stmtupdate;
        $addstmtquery = autodatacasting($addstmtquery,$api_data_array,$stmtdatatype);

    }else{
        $insertdetaileddateadsquery = addstmtadsquery($sql_table_name,$api_data_array,$database,$table_column_name,$api_type);
        $addstmtquery = stmtsetbindparamadd($counter,$converted_json,$api_data_array,$api_type,$action_stat,$cost_action_stat); 
        $addstmtquery = autodatacasting($addstmtquery,$api_data_array,$data_type_stmt);
        switch ($api_type){
            case "facebook":
                $stmtdatatype = $data_type_stmt.'s';
                array_push($addstmtquery,$api_account_name);
        break;
        }
    }; 
    mysqli_stmt_prepare($stmt, $insertdetaileddateadsquery);
    mysqli_stmt_bind_param($stmt, $stmtdatatype, ...$addstmtquery);
    mysqli_stmt_execute($stmt);
}
function curl_get_file_contents($URL)
{
        $c = curl_init();
        curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($c, CURLOPT_URL, $URL);
        $contents = curl_exec($c);
        curl_close($c);

        if ($contents) return $contents;
        else return FALSE;
}
?>

